--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()												returns time of day in seconds
--Return.Day()												returns day of month
--Return.Month()											returns month as number
--Return.Year()												returns year as number
--Return.Mission()											returns campaign mission number
--Return.CampFlag(flag-n)									returns value of campaign flag
--Return.AirUnitActive("UnitName")							returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")							returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")							returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")							returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")							returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")							returns percentage of alive sub elements in target
--Return.UnitDead(unitname)									(ADD) return vehicle/ship units dead (ADD)
--Return.GroupHidden("GroupName")							returns group hidden status
--Return.GroupProbability("GroupName")						returns group spawn probability value between 0 and 1
--Return.ShipGroupInPoly(GroupName, PolyZonesTable)			(ADD) return boolean whether ship group is in polygon (ADD)

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.TextPlayMission(arg)																--add trigger text to briefing text of this mission only if it is playable
--Action.SetCampFlag(flag-n, boolean/number)												--
--Action.AddCampFlag(flag-n, number)														--
--Action.AddImage("filname.jpg")															--
--Action.CampaignEnd("win"/"draw"/"loss")													--
--Action.TargetActive("TargetName", boolean)												--
--Action.AirUnitActive("UnitName", boolean)													--
--Action.AirUnitBase("UnitName", "BaseName")												--
--Action.AirUnitPlayer("UnitName", boolean)													--
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)				--
--Action.AirUnitRepair()																	--
--Action.GroundUnitRepair()																	-- (ADD) M19.f : Repair Ground
--Action.AddGroundTargetIntel("sideName")													--
--Action.GroupHidden("GroupName", boolean)													--
--Action.GroupProbability("GroupName", number 0-1)											--
--Action.GroupMove(GroupName, ZoneName)														-- (ADD) move vehicle group to refpoint (See the DC_CheckTriggers.lua file for more explanation)
--Action.GroupSlave(GroupName, master, bearing, distance)									-- (ADD)
--Action.ShipMission(GroupName, WPtable, CruiseSpeed, PatrolSpeed, StartTime)				-- (ADD) assign and run a movement mission to a ship group (See the DC_CheckTriggers.lua file for more explanation)
--Action.TemplateActive(TabFile)															-- (ADD) M40 : Template Active GroundGroup moving front (single file : active template) (if tab file: random activation)



--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			'Action.Text("April 1983, after the Iraqi brutal aggression against Iran in 1980 the 22nd of september, our army was able to repulse the enemy with the precious help of our Air Forces. The frontline is stabilized and the enemy is now trying to destroy our industrial sites and to terrorized our population bombing our cities. The mission of Islamic Republic of Iran Air Force is to stop enemy bombers, to attack the Irakian troops all along and back to the frontline and to respond with air raids on Irakian cities to their terror bombings.")',
			'Action.Text("The Irakian Air Force have considerable forces. Their main fighters are Mig-21 and Mig-23. The strike missions are made by Su-17 and Mig-23. Russian Mig-25 are trying to avoid our F-14 interceptions relying on their speed but they were not seen in our front sector for a long time. Iraq is trying desperatly to acquire new performing planes to challenge our air force so we should be ready to see any kind of new weapons against us. French Mirage F1 could be a serious threat for our troops. Their interceptor fighters are directed by ground based early warning radar and various SAMs are protecting the cities, the bases and the frontline. There are mainly SA-3 and SA-2 and short range SA-9 and manpads. Shilka and old 23mm twin guns are the main AAA danger")',
			'Action.Text("The Islamic Republic of Iran Air Force is flying a mix of F-14A, F-4E and F-5E-3 fighters directed by ground based early warning radar. Air bases and target complexes of high value are protected by west surface-air missile systems, such as the Hawk system and the Rapier, as well as short-range AAA.")',
			'Action.AddImage("Newspaper_FirstNight_blue.jpg", "blue")',
		},
	},
	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = false,
		condition = 'GroundTarget["blue"].percent < 60',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("Iranian Air Force have successfully destroyed enough Iraqi offensives forces preveting them to attack our country anymore. Iranian air power has once again proven its effectiveness and decisiveness. Well done.")',
			'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 2"] = {
		active = true,
		once = true,
		condition = 'Return.totalAirUnitAliveBySide("red") < 10',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("The Irakian Air Force is in ruins. After repeated air strikes and disastrous losses in air-air combat, the Irakians are no longer able to produce any sorties or offer any resistance. The IRIAF now owns complete air superiority. Iranian forces will certainly try to launch a new decisive attack on the frontline. Well done.")',
			'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("91 TFS") < 2',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("Ongoing combat operations have exhausted our Squadron. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of Iranian Air Force to attain air superiority, Iraqi forces will certainly try to launch a new decisive attack on the frontline. It s a bitter defeat for us")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss 3"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 50',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("Iraqian Air Force have successfully destroyed enough Iranian forces to allow a new offensive of enemy ground forces. Iranian air power was not efficient enough to stop Irakian offensive. This is a bitter failure.")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 60',
		action = {
			'Action.CampaignEnd("draw")',
			'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Islamic Republic Iranian Air Force and infrastructure, Iraqi Central Command has called off all squadrons from offensive operations. We hope we will be able to launch new attacks to repulse Iraqi invader soon.")',
			'NoMoreNewspaper = true',
		},
	},

----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 100',
		action = {
			'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
	},
	["Campaign 30 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 70',
		action = {
			'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
	},
	["Campaign 35 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 65',
		action = {
			'Action.Text("More than a third of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
		},
	},
	["Campaign Red first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 100',
		action = {
			'Action.Text("The enemy destroyed its first allied targets, you must defend them.")',
		},
	},
	["Campaign Red 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 80',
		action = {
			'Action.Text("The enemy destroyed nearly 20 percents of allied targets, you must defend them.")',
		},
	},
	["Campaign Red 30 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 70',
		action = {
			'Action.Text("Allies troops have sustained great damages. Enemy strike missions are too efficient and they will win this war soon")',
		},
	},
	["Campaign Red 45 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 55',
		action = {
			'Action.Text("Too much allied troops are neutralized. We will ask for a cease fire soon")',
		},
	},

	----- BLUE CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR-1") == 0 and Return.TargetAlive("EWR-2") == 0 and Return.TargetAlive("EWR-3") == 0',
		action = {
			'Action.TargetActive("CAP Larak", true)',
			'Action.TargetActive("CAP Frontline", true)',
			'Action.TargetActive("Lar Airbase 250 Km", false)',
			'Action.TargetActive("Shiraz Intl 250 Km", false)',
			'Action.TargetActive("Bandar Abbas Intl 150 Km", false)',
			'Action.TargetActive("Havadarya Alert", false)',
			'Action.Text("With the recent destruction of all our Early Warning Radar sites in the operations area, our ability to launch interceptors against enemy strike packages was severely degraded. We will have to increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
	},

	----- RED CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR 1") == 0 and Return.TargetAlive("EWR 2") == 0 and Return.TargetAlive("EWR 3") == 0',
		action = {
			'Action.TargetActive("Dubai Intl Alert", false)',
			'Action.TargetActive("Al Dhafra AB Alert", false)',
			'Action.TargetActive("Sharjah Intl Alert", false)',
			'Action.TargetActive("Al Maktoum Intl Alert", false)',
			'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
	},		
	
	----- REPAIR AND REINFORCEMENTS -----
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	
----------------------------  TANKER CONVOYS    -----------------------------------------------------

["Iranian Tanker convoy 3"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 10',
		action = {
		'Action.TemplateActive("Iranian Tanker convoy 3.stm")',
		'Action.TargetActive("Iranian Tanker convoy 3", true)',
		'Action.ShipMission("Iranian Tanker convoy 3", {{"Iranian Tanker convoy 3-1", "Iranian Tanker convoy 3-2", "Iranian Tanker convoy 3-3", "Iranian Tanker convoy 3-4", "Iranian Tanker convoy 3-5", "Iranian Tanker convoy 3-6"}}, 8, 5, nil)',
		'Action.Text("Intel has discovered that our Tankers convoys will be targeted soon by Irakian bombers")',
		},
	},

["Iranian Tanker convoy 2"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 10',
		action = {
		'Action.TemplateActive("Iranian Tanker convoy 2.stm")',
		'Action.TargetActive("Iranian Tanker convoy 2", true)',
		'Action.ShipMission("Iranian Tanker convoy 2", {{"Iranian Tanker convoy 2-1", "Iranian Tanker convoy 2-2", "Iranian Tanker convoy 2-3", "Iranian Tanker convoy 2-4", "Iranian Tanker convoy 2-5", "Iranian Tanker convoy 2-6"}}, 8, 5, nil)',
		'Action.Text("Intel has discovered that our Tankers convoys will be targeted soon by Irakian bombers")',
		},
	},
	
["Iranian Tanker convoy 1"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 10',
		action = {
		'Action.TemplateActive("Iranian Tanker convoy 1.stm")',
		'Action.TargetActive("Iranian Tanker convoy 1", true)',
		'Action.ShipMission("Iranian Tanker convoy 1", {{"Iranian Tanker convoy 1-1", "Iranian Tanker convoy 1-2", "Iranian Tanker convoy 1-3", "Iranian Tanker convoy 1-4", "Iranian Tanker convoy 1-5", "Iranian Tanker convoy 1-6"}}, 8, 5, nil)',
		'Action.Text("Intel has discovered that our Tankers convoys will be targeted soon by Irakian bombers")',
		},
	},


		----- UNIT ACTIVATION -----
	["Unit Activate Mig-25RBT"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 10',
		action = {
			'Action.AirUnitActive("83 Squadron", true)',
			'Action.Text("Intel has discovered that russians new Mig-25 has deployed in Iraq. Their main missions should be Reconnaissance and high altitude bombing")',
			'Action.TargetActive("Recon Frontline", true)',
			'Action.TargetActive("Recon Bandar Abas Airbase", true)',
			'Action.TargetActive("Recon navigation lines", true)',			
		},
	},
	["Unit Activate MiG-27K"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			'Action.AirUnitActive("300 IAP", true)',
			'Action.Text("Reconnaissance has detected that a russian squadron of Mig-27 fighter has deployed In Iraq. Intelligence estimates that these Mig may at least partially be equipped with Air to ground and ARM missiles. They will be priority targets for our fighters")',
		},
	},
	["Unit Activate MiG-25"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 5',
		action = {
			'Action.AirUnitActive("23 Squadron", true)',
			'Action.Text("Reconnaissance has discovered a small number of MiG-25 Foxbat interceptors in Iraq. While the operational readiness of the aircraft is estimated to be low, this mach 3 interceptor is flown by the elite of the pilot cadre and poses a serious threat to our strike missions when encountered. All crews are advised to handle the Foxbat with utmost respect.")',
			'Action.AddImage("Recon_MiG-25_1.jpg")',
			'Action.AddImage("Recon_MiG-25_2.jpg")',
		},
	},
	["Unit Activate Mirage F1CT"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 10',
		action = {
			'Action.AirUnitActive("81 Squadron", true)',
			'Action.Text("Reconnaissance has discovered a french built Mirage F1 EQ5 Squadron in Iraq. This plane will be the main danger for structures and ships because of its good weapons loadouts. They are priority targets.")',
		},
	},
	["Unit Activate Mirage F1 EQ"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 3',
		action = {
			'Action.AirUnitActive("79 Squadron", true)',
			'Action.Text("Reconnaissance has discovered a french built Mirage F1 EQ Squadron in Iraq. This will be the main danger for our troops because of its weapons loadouts and best french technology . All crews are advised to handle the Mirage with utmost respect.")',
		},
	},	
	
	
	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
	
}







